***************************************************************
* Read in data
***************************************************************

set more off
clear
* Put name of your main directory path here:
local main = "___"
cd `main'

set more off
import excel "Figure 16\Figure 16 - chart data.xlsx", sheet("Plot Series") cellrange(B1:D152) firstrow clear

***************************************************************
* Set color scheme (optional)
***************************************************************

set scheme s1color

***************************************************************
* Data work
***************************************************************

rename t date
destring date, replace
gen t = quarterly(date, "YQ")
format t %tq
drop date
sort t

g Actual = SPFlongtermActual

***************************************************************
* Chart
***************************************************************

sum t if t==tq(1998q2)
local t1 = r(mean)
sum t if t==tq(2008q2)
local t2 = r(mean)
sum t if t==tq(2020q1)
local t3 = r(mean)

line Actual Fitted t, ///
lpattern(solid dash) lwidth(medthick medthick) ///
xline(`t1' `t2' `t3', lcolor(ebg)) ///
ylabel(1(.5)5) ///
ttext(1.5 1985q1 "{&gamma} = 0.945", placement(east)) ///
ttext(1.5 1998q2 "{&gamma} = 1.003", placement(east)) ///
ttext(1.5 2008q2 "{&gamma} = 0.991", placement(east)) ///
ttext(1.5 2020q1 "{&gamma} = 0.980", placement(0)) ///
lcolor(blue red) lwidth(medthick medthick) ///
xtitle("") legend(row(5)) xtitle("") ///
xmtick(#37) xlabel(, format(%tqCY)) xlabel(,labsize(medium)) ylabel(,labsize(medium)) xtitle("") ytitle("") ///
legend(row(1) symxsize(4) ring(0) position(12) bmargin(none) region(style(none))) xsize(5)
